#!/usr/local/bin/perl
# $Id: news2mail.pl,v 1.2 1998/01/28 15:23:34 jr6b Exp $
# Turn news spool into mail
# Written by Chris Browne <cbbrowne@hex.net>

# The following values will have to be customized to represent *YOUR* file
# locations
$SOURCE = "/home/cbbrowne/News/slrnpull/news/";   # Where do we find news?

$DEST = "/home/cbbrowne/News/slrnpull/news/news2mail.$$";   # Temporary location for messages
# Note: it is preferable for $DEST to be on the same partition as $SOURCE.
# This has the salutory effect that the "mv" command doesn't cross
# partitions, and thus *THIS* process never needs to actually copy the file.
# mv on the same partition         ---> merely renames the file
# mv from one partition to another ---> duplicates and renames the file

# Note: By using .$$, we insert the PID as the file "suffix." This allows
# multiple copies of this script to execute concurrently without getting
# confused and working on each others' files.

$IFILTER = "/usr/local/bin/ifilter.mh";   # Where's ifilter?

open(FIND, "find $SOURCE | ");   # Find all the files in the news spool
while ($file=<FIND>) {
    if ($file =~ /^(.*\/\d+)\s*$/) {  # Only work with those that are articles
        $filename = $1;

        # Note that the mv is done *before* ifilter is run.  This means that
        # the news article "disappears" from the spool before ifilter
        # processing starts.  

        # This means that we can run multiple copies of this script in
        # parallel and they will all behave well together.  It is dubious
        # whether this will increase throughput on a single processor system,
        # since once .idata is in the system cache, ifilter becomes CPU-bound.
        # But at least this means that the system doesn't blow chunks if two
        # copies get started in parallel...
        if (-e $filename) { # Is the file still there?
           $articles++;
           $command = "mv $filename $DEST;";    # Move file to fixed location
           $command .= $IFILTER . " < " . $DEST;  # Run ifilter on the file
           # $command = ";mv $DEST $filename";  # Move the file back into place
           print "$command\n";
           `$command`;                          # Now, execute the command...
        } else {
           print "Already gone: $file";     # Something's already nuked it...
        }
    } else {
        print "Not filtering $file";
    }
}

print "Total articles processed: $articles\n";
unlink $DEST;  # Clean up at the end...
