#!/usr/bin/perl
# Copyright (c) 2003 Robert N. M. Watson
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

use Net::DNS;
use Net::hostent;

$res = Net::DNS::Resolver->new;
$res->nameservers('204.156.12.50');

#
# Two passes: first, build IP list
#
foreach $file (`ls data/`) {
	chop($file);
	print $file."\n";

	open(FILE, "data/".$file);
	$timestamp = <FILE>;
	chop($timestamp);
	while (<FILE>) {
		chop($_);
		($ip, $len) = split(/:/, $_);
		$iplist{$ip} = 1;
	}
	close(FILE);
}

open(OUTFILE, ">bpfmon.out");
print OUTFILE "timestamp:";
foreach $key (keys %iplist) {

	#
	# Attempt to generate a hostname.
	#
	($oct1, $oct2, $oct3, $oct4) = split(/\./, $key);
	$inaddr = $oct4.".".$oct3.".".$oct2.".".$oct1.".in-addr.arpa.";
	$query = $res->search($inaddr, "PTR");
	if ($query) {
		$hostname = undefined;
		foreach $rr ($query->answer) {
			next unless $rr->type eq "PTR";
			$hostname = $rr->ptrdname;
		}
	}

	if (defined($hostname)) {
		print OUTFILE $hostname.":";
	} else {
		print OUTFILE $key.":";
	}
}
print OUTFILE "\n";

foreach $file (`ls data/`) {
	chop($file);

	${ipdata} = {};

	open(FILE, "data/".$file);
	$timestamp = <FILE>;
	chop($timestamp);
	while (<FILE>) {
		chop($_);
		($ip, $len) = split(/:/, $_);
		$ipdata{$ip} = $len * 8 / (60 * 5);
	}
	close(FILE);

	print OUTFILE $timestamp.":";
	foreach $key (keys %iplist) {
		if (defined($ipdata{$key})) {
			print OUTFILE $ipdata{$key}.":";
		} else {
			print OUTFILE "0:";
		}
	}
	print OUTFILE "\n";
}
