#include <sys/types.h>
#include <sys/syscall.h>

#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define JAIL_CREATE     1
#define JAIL_DESTROY    2
#define JAIL_JOIN       3

extern char *environ[];

static void
usage(void)
{

	fprintf(stderr, "usage:\n");
	fprintf(stderr, "  jailctl create [jailname]\n");
	fprintf(stderr, "  jailctl destroy [jailname]\n");
	fprintf(stderr, "  jailctl join [jailname] [-c chrootpath] [path] "
	    "[cmd] [args...]\n");

	exit(-1);
}

static int
jail_create(int argc, char *argv[])
{
	int error;

	if (argc < 2)
		usage();

	error = syscall(375, JAIL_CREATE, argv[1]);
	if (error)
		perror("jailconf().create");
	return (error);
}

static int
jail_destroy(int argc, char *argv[])
{
	int error;

	if (argc < 2)
		usage();

	error = syscall(375, JAIL_DESTROY, argv[1]);
	if (error)
		perror("jailconf().destroy");
	return (error);
}

static int
jail_join(int argc, char *argv[])
{
	char *chrootpath = NULL, *jailname = NULL;
	int error, ch;

	if (argc < 3)
		usage();

	jailname = strdup(argv[1]);

	argc-=2;
	argv+=2;

	optind = 0;
	while ((ch = getopt(argc, argv, "c:")) != -1)
		switch (ch) {
		case 'c':
			chrootpath = strdup(optarg);
			break;
		default:
			usage();
		}

	argc -= optind;
	argv += optind;

	if (argc < 1)
		usage();

	if (chrootpath != NULL) {
		error = chdir(chrootpath);
		if (error) {
			perror(chrootpath);
			return (-1);
		}
		error = chroot(chrootpath);
		if (error) {
			perror(chrootpath);
			return (-1);
		}
	}

	error = syscall(375, JAIL_JOIN, jailname);
	if (error) {
		perror(jailname);
		return (error);
	}

	error = execve(argv[0], argv, environ);
	if (error)
		perror(argv[0]);

	return (error);
}

int
main(int argc, char *argv[])
{

	if (argc < 2)
		usage();

	if (!strcmp(argv[1], "create"))
		return (jail_create(argc-1, argv+1));
	else if (!strcmp(argv[1], "destroy"))
		return (jail_destroy(argc-1, argv+1));
	else if (!strcmp(argv[1], "join"))
		return (jail_join(argc-1, argv+1));
	else
		usage();

	return (0);
}
