/*-
 * Copyright (c) 2005-2006 Robert N. M. Watson
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * Simple TCP/IP wrapper for packet library, pulls out IP and TCP headers
 * without associated options.  Having variants that pull out just the
 * headers without skipping the options would also be desirable, along with
 * routines for managing option parsing.
 */

#include <sys/types.h>

#define	__FAVOR_BSD						/* Linux. */

#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>

#include <pcap.h>

#include "queue.h"
#include "packet.h"
#include "tcpip.h"

/*
 * Read IP header from packet; skip options.
 */
int
packet_get_ip(struct packet *p, struct ip *ip)
{

	if (packet_get_data(p, sizeof(*ip), ip) < 0)
		return (-1);

	if (packet_skip_data(p, (ip->ip_hl << 2) - sizeof(*ip)) < 0)
		return (-1);

	return (0);
}

/*
 * Read TCP header from packet; skip options.
 */
int
packet_get_tcp(struct packet *p, struct tcphdr *tcp)
{

	if (packet_get_data(p, sizeof(*tcp), tcp) < 0)
		return (-1);

	if (packet_skip_data(p, (tcp->th_off << 2) - sizeof(*tcp)) < 0)
		return (-1);

	return (0);
}
